using System;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Win32;

namespace gov.va.med.vbecs.GUI.controls
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/11/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		/// <summary>
		/// Utility class which can be used by any Windows form to save and restore location, size and window state
		/// </summary>

		#endregion

	public class PersistWindowState : System.ComponentModel.Component
	{
		/// <summary>
		/// Delegate to be used as event handler for LoadStateEvent and SaveStateEvent
		/// </summary>
		public delegate void WindowStateEventHandler(object sender, System.EventArgs e, RegistryKey key);

		/// <summary>
		/// Load State Event. Fired when loading form state details from registry
		/// </summary>
		public event WindowStateEventHandler LoadStateEvent;

		/// <summary>
		/// Save State Event. Fired when saving form state details to registry
		/// </summary>
		public event WindowStateEventHandler SaveStateEvent;

		private Form _parent;
		private string _regPath;
		private int _normalLeft, _normalTop, _normalWidth, _normalHeight;
		private FormWindowState _windowState;
		private bool _allowSaveMinimized = false;

		/// <summary>
		/// PersistWindowState constructor. Accepts parent form and registry path string.
		/// </summary>
		/// <param name="parentForm">Parent form</param>
		/// <param name="registryPath">Registry path string</param>
		public PersistWindowState(Form parentForm,string registryPath)
		{
			this.Parent = parentForm;
			this.RegistryPath = registryPath;
		}

		/// <summary>
		/// Gets and sets Parent form
		/// </summary>
		public Form Parent
		{
			get
			{
				return this._parent;
			}
			set
			{
				this._parent = value;
				//
				//subscribe to parent form's events
				this._parent.Closing += new System.ComponentModel.CancelEventHandler(OnClosing);
				this._parent.Resize += new System.EventHandler(OnResize);
				this._parent.Move += new System.EventHandler(OnMove);
				this._parent.Load += new System.EventHandler(OnLoad);
				//
				//get initial width and height, in case it is never resized
				_normalWidth = this._parent.Width;
				_normalHeight = this._parent.Height;
			}
		}

		/// <summary>
		/// Gets and sets registry path string
		/// </summary>
		public string RegistryPath
		{
			get
			{
				return this._regPath;
			}
			set
			{
				this._regPath = value;
			}
		}

		/// <summary>
		/// Gets and sets indication of whether a window state of minimized should be saved
		/// </summary>
		public bool AllowSaveMinimized
		{
			get
			{
				return this._allowSaveMinimized;
			}
			set
			{
				this._allowSaveMinimized = value;
			}
		}

		/// <summary>
		/// Parent form Resize event handler, updates size information
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void OnResize(object sender, System.EventArgs e)
		{
			//save width and height
			if (this._parent.WindowState == FormWindowState.Normal)
			{
				this._normalWidth = this._parent.Width;
				this._normalHeight = this._parent.Height;
			}
		}

		/// <summary>
		/// Parent form Move event handler, updates location information
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void OnMove(object sender, System.EventArgs e)
		{
			//save position
			if (this._parent.WindowState == FormWindowState.Normal)
			{
				this._normalLeft = this._parent.Left;
				this._normalTop = this._parent.Top;
			}
			//
			//Save state
			this._windowState = this._parent.WindowState;
		}

		/// <summary>
		/// Parent form Closing event handler, saves form state to registry
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Cancel Event args</param>
		private void OnClosing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			//save position, size and state to registry
			RegistryKey key = Registry.CurrentUser.CreateSubKey(this._regPath);
            //CR 3554
		    if (key != null)
		    {
		        key.SetValue("Left",this._normalLeft);
		        key.SetValue("Top",this._normalTop);
		        key.SetValue("Width",this._normalWidth);
		        key.SetValue("Height",this._normalHeight);
		        //
		        if ((!this._allowSaveMinimized) && (this._windowState == FormWindowState.Minimized))
		        {
		            this._windowState = FormWindowState.Normal;
		        }
		        key.SetValue("WindowState",(int)this._windowState);
		        //
		        if (SaveStateEvent != null)
		        {
		            SaveStateEvent(this, e, key);
		        }
		    }
		}

		/// <summary>
		/// Parent form Load event handler, retrieves form state from registry
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void OnLoad(object sender, System.EventArgs e)
		{
			//read position, size and state from registry
			RegistryKey key = Registry.CurrentUser.OpenSubKey(this._regPath);
			//
			if (key != null)
			{
				int left = (int)key.GetValue("Left",this._parent.Left);
				int top = (int)key.GetValue("Top",this._parent.Top);
				int width = (int)key.GetValue("Width",this._parent.Width);
				int height = (int)key.GetValue("Height",this._parent.Height);
				FormWindowState windowState = (FormWindowState)key.GetValue("WindowState",(int)this._parent.WindowState);
				//
				this._parent.Location = new Point(left, top);
				this._parent.Size = new Size(width, height);
				this._parent.WindowState = windowState;
				//
				if (LoadStateEvent != null)
				{
					LoadStateEvent(this, e, key);
				}
			}
		}
	}
}
